import pandas as pd
import pickle

atp_tennis = pd.read_csv("atp_tennis.csv")

# Create a new DataFrame with separate rows for each player   
player_data = pd.DataFrame(columns=['Player', 'Rank', 'Win_Loss_Ratio', 'Surface', 'Date'])   

# Add Player_1 data to the new DataFrame   
player_data_1 = atp_tennis[['Player_1', 'Rank_1', 'Win_Loss_Ratio_1', 'Surface', 'Date']].copy()   
player_data_1.columns = ['Player', 'Rank', 'Win_Loss_Ratio', 'Surface', 'Date']   

# Add Player_2 data to the new DataFrame   
player_data_2 = atp_tennis[['Player_2', 'Rank_2', 'Win_Loss_Ratio_2', 'Surface', 'Date']].copy()   
player_data_2.columns = ['Player', 'Rank', 'Win_Loss_Ratio', 'Surface', 'Date']   

# Concatenate Player_1 and Player_2 data   
player_data = pd.concat([player_data_1, player_data_2], ignore_index=True) 

print(player_data)
pickle.dump(player_data,open("./ref_result/player_data.pkl","wb"))